<?php

if (!function_exists('siteSettings')) {
    /**
     * Get site settings helper instance or specific setting
     *
     * @param string|null $key
     * @param mixed $default
     * @return mixed
     */
    function siteSettings($key = null, $default = null)
    {
        if ($key === null) {
            return \App\Helpers\SiteSettingsHelper::getAllFormatted();
        }

        return \App\Helpers\SiteSettingsHelper::get($key, $default);
    }
}

if (!function_exists('serverRates')) {
    /**
     * Get server rates
     *
     * @return array
     */
    function serverRates()
    {
        return \App\Helpers\SiteSettingsHelper::getServerRates();
    }
}

if (!function_exists('socialLinks')) {
    /**
     * Get social media links
     *
     * @return array
     */
    function socialLinks()
    {
        return \App\Helpers\SiteSettingsHelper::getSocialLinks();
    }
}

if (!function_exists('serverLimits')) {
    /**
     * Get server limits
     *
     * @return array
     */
    function serverLimits()
    {
        return \App\Helpers\SiteSettingsHelper::getServerLimits();
    }
}
