<?php

namespace App\Helpers;

use App\Models\FastEvent;
use Illuminate\Support\Facades\View;

class FastEventHelper
{
    /**
     * Get all active fast events
     */
    public static function getActiveEvents()
    {
        return FastEvent::active()->get();
    }

    /**
     * Get a specific event by ID
     */
    public static function getEvent($id)
    {
        return FastEvent::find($id);
    }

    /**
     * Render a fast event by blade name
     */
    public static function renderEvent($bladeName, $eventId = null)
    {
        $viewPath = "livewire.fastEvents.{$bladeName}";

        if (View::exists($viewPath)) {
            return view($viewPath, compact('eventId'))->render();
        }

        return "<!-- Event view '{$bladeName}' not found -->";
    }

    /**
     * Check and disable expired events
     */
    public static function checkExpiredEvents()
    {
        $expiredEvents = FastEvent::where('is_active', true)
            ->where('expired_at', '<', now())
            ->get();

        foreach ($expiredEvents as $event) {
            $event->update(['is_active' => false]);
        }

        return $expiredEvents->count();
    }

    /**
     * Get events that will expire soon (within 24 hours)
     */
    public static function getExpiringEvents()
    {
        return FastEvent::active()
            ->where('expired_at', '<=', now()->addDay())
            ->get();
    }
}
