<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CheckExpiredEvents extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'events:check-expired';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check and disable expired fast events';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $disabledCount = \App\Helpers\FastEventHelper::checkExpiredEvents();

        if ($disabledCount > 0) {
            $this->info("تم إيقاف {$disabledCount} أحداث منتهية الصلاحية.");
        } else {
            $this->info('لا توجد أحداث منتهية الصلاحية.');
        }

        return 0;
    }
}
